/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemCloseHandler;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.RsfResult;
import com.ibm.hwmca.fw.rsf.RsfResultProcessor;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.rsf.PIRepairVerifyRequestBody;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;

public class PIProblemCloseHandler
implements ProblemCloseHandler,
RsfResultProcessor,
ServiceAgentAttr {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private static final String CLASS_NAME = "[PIProblemCloseHandler] ";

    public void closeProblem(Problem problem) throws HException {
        Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] closeProblem");
        if (problem instanceof PIProblem) {
            PIProblem theProblem = (PIProblem)problem;
            ServiceAgentAttr.ESAreportingMachInfo rep = ServiceAgentUtils.getReportingMachineInfo(theProblem);
            boolean RSFSetting = ServiceAgentUtils.ESACheckRSF(rep.machType, rep.machModel, rep.machSerial);
            if (RSFSetting) {
                String pmh = theProblem.getPMH();
                if (pmh != null && pmh.length() > 0) {
                    Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] close pmh: " + pmh);
                    byte block = 3;
                    Log theLog = new Log(-86, -45, 0, "SaPAPCloReq", null, null, null, null);
                    PIRepairVerifyRequestBody rvBody = new PIRepairVerifyRequestBody();
                    if (rvBody != null) {
                        rvBody.putAttribute("PMH NUMBER", pmh);
                        rvBody.putAttribute("Close pmh", "Y");
                        ServiceAgentAttr.ESApapRequest papRequest = new ServiceAgentAttr.ESApapRequest();
                        papRequest.requestType = "Problem_Close";
                        papRequest.problemUUID = theProblem.getUniqueKey();
                        rvBody.setUserAttachement(papRequest);
                        rvBody.setReportingMachineInfo(new RsfMachineInfo(rep.machType, rep.machModel, rep.machSerial));
                        RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
                        if (rsf != null) {
                            RsfRequest req = rsf.newRequestInstance(rvBody, this.getClass().getName(), new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA.cat.problem"));
                            if (req != null) {
                                Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] req.submit()");
                                req.submit();
                                theLog.add((byte)3, req.getId());
                                block = (byte)(block + 1);
                                theLog.add(block, rvBody);
                                theLog.log();
                            } else {
                                Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] req was null");
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] rsf was null");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] rvBody was nul");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] pmh not set");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] RSF not enabled: " + RSFSetting);
            }
        } else {
            Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] not a PIProblem");
        }
    }

    public void rsfRequestCompleted(RsfRequest request, RsfResult result) {
        PIProblem theProblem = null;
        ProblemManager pm = null;
        if (result != null) {
            int status = result.getStatusCode();
            if (status == 1) {
                Trace.trace(TRACE_MASKD, "[PIProblemCloseHandler] StatusCode = rsfResult.RESULT_OK");
            } else if (status == 2) {
                Trace.trace(TRACE_MASKD, "[PIProblemCloseHandler] StatusCode = rsfResult.RESULT_FAILED");
                Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] getReasonCode: " + result.getReasonCode());
                Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] getReasonMessage: " + result.getReasonMessage());
            } else {
                Trace.trace(TRACE_MASKD, "[PIProblemCloseHandler] unknown StatusCode = " + status);
                Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] getReasonCode: " + result.getReasonCode());
                Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] getReasonMessage: " + result.getReasonMessage());
            }
        } else {
            Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] result was null");
        }
        if (request != null) {
            PIRepairVerifyRequestBody rvBody = (PIRepairVerifyRequestBody)request.getBody();
            if (rvBody != null) {
                byte block = 3;
                Log theLog = new Log(-86, -45, 0, "SaPAPCloRes", null, null, null, null);
                theLog.add((byte)3, request.getId());
                block = (byte)(block + 1);
                theLog.add(block, result);
                theLog.log();
                ServiceAgentAttr.ESApapRequest papRequest = (ServiceAgentAttr.ESApapRequest)rvBody.getUserAttachment();
                if (papRequest.problemUUID != null && papRequest.problemUUID.length() > 0) {
                    try {
                        pm = ProblemManager.getProblemManager();
                        theProblem = (PIProblem)pm.getProblem(papRequest.problemUUID);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKD, "[PIProblemCloseHandler] pm exception");
                        Trace.trace(TRACE_MASKD, CLASS_NAME + e);
                    }
                    if (theProblem != null) {
                        Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] ProblemNumber: " + theProblem.getProblemNumber());
                        Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] PMH: " + theProblem.getPMH());
                    } else {
                        Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] theProblem was null");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] problemUUID not set");
                }
            } else {
                Trace.trace(TRACE_MASKD, "[PIProblemCloseHandler] rvBody was null");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[PIProblemCloseHandler] request was null");
        }
    }
}

